-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.thallDefeat:LinkToTarget("defeat")
  end
end

function OnTrigger(self, sourceName, targetName)
  self.p0:SwitchOwnership(Game:GetEntity(self:GetKey()), 0)
  self.p0:SetTownhallScript(self)
end

function OnBeforeDeath(self)
  self.p0:FailQuest('D2_GOAL_1')
  self.thallDefeat:TriggerAllTargets() 
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("suTownBuilding")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("thallDefeat")
end
